/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.vfs.impl;

import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;
import org.gradle.internal.snapshot.AtomicSnapshotHierarchyReference;
import org.gradle.internal.snapshot.SnapshotHierarchy;
import org.gradle.internal.vfs.impl.SnapshotCollectingDiffListener;

public class DelegatingDiffCapturingUpdateFunctionDecorator
implements SnapshotHierarchy.DiffCapturingUpdateFunctionDecorator {
    private final Predicate<String> watchFilter;
    private ErrorHandlingDiffPublisher errorHandlingDiffPublisher;

    public DelegatingDiffCapturingUpdateFunctionDecorator(Predicate<String> watchFilter) {
        this.watchFilter = watchFilter;
    }

    public void setSnapshotDiffListener(SnapshotHierarchy.SnapshotDiffListener snapshotDiffListener, ErrorHandler errorHandler) {
        this.errorHandlingDiffPublisher = new ErrorHandlingDiffPublisher(snapshotDiffListener, errorHandler);
    }

    public void stopListening() {
        this.errorHandlingDiffPublisher = null;
    }

    public AtomicSnapshotHierarchyReference.UpdateFunction decorate(SnapshotHierarchy.DiffCapturingUpdateFunction updateFunction) {
        ErrorHandlingDiffPublisher currentErrorHandlingDiffPublisher = this.errorHandlingDiffPublisher;
        if (currentErrorHandlingDiffPublisher == null) {
            return root -> updateFunction.update(root, SnapshotHierarchy.NodeDiffListener.NOOP);
        }
        SnapshotCollectingDiffListener diffListener = new SnapshotCollectingDiffListener(this.watchFilter);
        return root -> {
            SnapshotHierarchy newRoot = updateFunction.update(root, (SnapshotHierarchy.NodeDiffListener)diffListener);
            return currentErrorHandlingDiffPublisher.publishSnapshotDiff(diffListener, newRoot);
        };
    }

    private static class ErrorHandlingDiffPublisher {
        private final SnapshotHierarchy.SnapshotDiffListener diffListener;
        private final ErrorHandler errorHandler;

        public ErrorHandlingDiffPublisher(SnapshotHierarchy.SnapshotDiffListener diffListener, ErrorHandler errorHandler) {
            this.diffListener = diffListener;
            this.errorHandler = errorHandler;
        }

        public SnapshotHierarchy publishSnapshotDiff(SnapshotCollectingDiffListener collectedDiff, SnapshotHierarchy newRoot) {
            return this.errorHandler.handleErrors(newRoot, () -> collectedDiff.publishSnapshotDiff(this.diffListener));
        }
    }

    public static interface ErrorHandler {
        @CheckReturnValue
        public SnapshotHierarchy handleErrors(SnapshotHierarchy var1, Runnable var2);
    }
}

